<?php
require("conexao.php");

function parseToXML($htmlStr){
	$xmlStr=str_replace('<','&lt;',$htmlStr);
	$xmlStr=str_replace('>','&gt;',$xmlStr);
	$xmlStr=str_replace('"','&quot;',$xmlStr);
	$xmlStr=str_replace("'",'&#39;',$xmlStr);
	$xmlStr=str_replace("&",'&amp;',$xmlStr);
	return $xmlStr;
}

   
header("Content-type: text/xml");

// Start XML file, echo parent node
echo '<markers>'; 

$Evento = ControladorEvento::ctrMostrarTodosEventosPorEstado("Não Realizado");
// Select all the rows in the markers table
foreach ($Evento as $key => $row_markers) {
// Iterate through the rows, printing XML nodes for each

  // Add to XML document node
  echo '<marker ';
  echo 'name="' . parseToXML($row_markers['titulo']) . '" ';
  echo 'address="' . parseToXML($row_markers['endereco']) . '" ';
  echo 'lat="' . $row_markers['latitude'] . '" ';
  echo 'lng="' . $row_markers['longitude'] . '" ';
  echo 'type="' . $row_markers['tipoEvento'] . '" ';
  echo '/>';
}

// End XML file
echo '</markers>';



